- cam
  CameraControl
    _Amount = 0
    Dolly =       6 * filter(IntensityFromMidiCC(1, 20)-0.5, 1.5) 
    X =           6 * filter(IntensityFromMidiCC(1, 21)-0.5, 1.5) 
    Z =           6 * filter(IntensityFromMidiCC(1, 22)-0.5, 1.5) 
    FOV =   35 + 50 * filter(IntensityFromMidiCC(1, 23)-0.5, 1.5) 
    Y =           6 * filter(IntensityFromMidiCC(1, 30)-0.5, 1.5) - 4 * filter(IntensityFromMidiCC(1, 86), 1.5)
    Orbit =     360 * filter(IntensityFromMidiCC(1, 27)-0.5, 1.6)   
    TiltOrbit = 180 * filter(IntensityFromMidiCC(1, 26)-0.5, 1.5) 
    Roll =       45 * filter(IntensityFromMidiCC(1, 25)-0.5, 1.5)  
    
- BLACKFADE ON TOP
  ShaderRect ; Shader = "black-fade-on-top" ; SkyBox = true ; SizeInScene = 1000
    Intensity = 1.0-filter(IntensityFromMidiCC(1, 89), 0.2)
    RenderQueue = 3005

- BG 
  ShaderRect ; Material = "dark-noise" ; SkyBox = true ; SizeInScene = 1200
    _BaseSize = 0.20 
    _Animate = 1 

- CLOUDS - BG ONLY  
  ShaderRect ; Material = "cloudsbg" ; SkyBox = true ; SizeInScene = 1100
    Intensity = linearstep(0,0.001,IntensityFromMidiCC(1, 31))
    RenderQueue = 2998
    _BackgroundOpacity = IntensityFromMidiCC(1, 31)

- CLOUDS  
  ShaderRect ; Material = "clouds" ; SkyBox = true ; SizeInScene = 1000
    Intensity = pow(  smoothstep(0.01,1.0,  Filter(FrameIntensityFromMidi(3, 12), 0.1, 0.006)  )  , 2)
    RenderQueue = 3001 
    _BackgroundOpacity = 1 - IntensityFromMidiCC(1, 31)
    _LocalTime = filter(FramePosFromMidi(3, 12), 1) / 90 + 21.12
    _BaseSize = 0.20 
    _BaseGradient = 4 * filter(IntensityFromMidiCC(1, 15)-0.5, 1.5) 
    _BaseOffset = filter(IntensityFromMidiCC(1, 16)-0.5, 2) 
    _DensityCutoff = filter(IntensityFromMidiCC(1, 17), 2) 
    _Animate = 1

- BIRDS  
  Birds
    BirdCount = 10
    LocalTime = filter(FramePosFromMidi(3, 12), 1) / 90 
    Intensity = filter(IntensityFromMidiCC(1, 18), 1) 
    PositionDistribution = vec3(21, 5, 9)
    FarFade = 1
    Far = 30
    Matrix = MatrixFromTRS(-6,2.2,15-1*(filter(FramePosFromMidi(3, 12), 1) / 90 - 30), 0,-12,0, 0.4)

- CITY
  City
    Matrix = MatrixFromTRS(0,-21 + 4 * filter(IntensityFromMidiCC(1, 86), 1.5),43, 0,-90,0, 2)
    Intensity = filter(IntensityFromMidiCC(1, 19), 1)
    OffsetX = -3 * filter(FramePosFromMidi(3, 32), 1) / 90
    Twist = filter(IntensityFromMidiCC(1, 85), 1)
    Night = filter(IntensityFromMidiCC(1, 84), 1)
    Cut = IntensityFromMidiCC(1, 87)  
    PlacementScale = vec3(4, 8 + 200 * filter(IntensityFromMidiCC(1, 88), 4), 2)
    _Greetings = filter(IntensityFromMidiCC(1, 89), 1)
    Greetings2 = floor(IntensityFromMidiCC(1, 90) * 10) - 1
    TwistByHeight = 0.7  
    TwistTime = 0.1 * filter(FramePosFromMidi(3, 32), 1) / 90
    TwistFold = 0.02
    _FogFadeAlpha = 2 
    _ShadowLightThreshold = 0.0

- END LOGO
  ShaderRect ; Material = "teadrinker-logo-anim" ; SizeInScene = 100
    Intensity = FrameIntensityFromMidi(3, 16) 
    Aspect = 1
    _Size = 0.125
    _LocalTime = FramePosFromMidi(3, 16) / 90
    RenderQueue = 3006


- PARTICLES
  Particles
    Matrix = MatrixFromTRS(0,1.25,0, 0,0,0, 1)
    Size = 2
    SizeV = 0.9
    Intensity = FrameIntensityFromMidi(3, 14) 
    LifeDuration = 4
    Flow = 0.2
    EmitterSize = vec3(7,2.5,7)
    Direction = vec3(-1,0,0)
    RenderStyle = 32
    Tail = 40 + 70 * IntensityFromMidi(1,19)
    Velocity = 3
    VelocityV = 2/3
    Spread = 0.0



